/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.swing.text;

import java.awt.Color;

public class HighlightStyle {
    public static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public static final HighlightStyle DEFAULT_STYLE = new HighlightStyle(Color.black, false, false);
    private Color color;
    private boolean bold;
    private boolean italic;

    public HighlightStyle(Color color, boolean bold, boolean italic) {
        if (color == null) {
            throw new NullPointerException();
        }
        this.color = color;
        this.bold = bold;
        this.italic = italic;
    }

    public Color getColor() {
        return this.color;
    }

    public boolean isBold() {
        return this.bold;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public int getStyleMask() {
        return (this.bold ? 1 : 0) | (this.italic ? 2 : 0);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof HighlightStyle) {
            HighlightStyle style = (HighlightStyle)obj;
            return this.bold == style.bold && this.italic == style.italic && this.color.equals(style.color);
        }
        return false;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append('#');
        int tempInt = this.color.getRed();
        buffer.append(HEX_DIGITS[tempInt >> 4 & 0xF]);
        buffer.append(HEX_DIGITS[tempInt & 0xF]);
        tempInt = this.color.getGreen();
        buffer.append(HEX_DIGITS[tempInt >> 4 & 0xF]);
        buffer.append(HEX_DIGITS[tempInt & 0xF]);
        tempInt = this.color.getBlue();
        buffer.append(HEX_DIGITS[tempInt >> 4 & 0xF]);
        buffer.append(HEX_DIGITS[tempInt & 0xF]);
        buffer.append('-');
        if (this.bold) {
            buffer.append("BOLD");
        }
        buffer.append('-');
        if (this.italic) {
            buffer.append("ITALIC");
        }
        return buffer.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HighlightStyle parseStyle(String string) {
        boolean italic;
        boolean bold;
        int length = string.length();
        if (length == 9) {
            if (!string.endsWith("--")) return null;
            bold = false;
            italic = false;
        } else if (length == 13) {
            if (!string.endsWith("-BOLD-")) return null;
            bold = true;
            italic = false;
        } else if (length == 15) {
            if (!string.endsWith("--ITALIC")) return null;
            bold = false;
            italic = true;
        } else {
            if (length != 19) return null;
            if (!string.endsWith("-BOLD-ITALIC")) return null;
            bold = true;
            italic = true;
        }
        if (string.charAt(0) != '#' || !HighlightStyle.isHexDigit(string.charAt(1)) || !HighlightStyle.isHexDigit(string.charAt(2)) || !HighlightStyle.isHexDigit(string.charAt(3)) || !HighlightStyle.isHexDigit(string.charAt(4)) || !HighlightStyle.isHexDigit(string.charAt(5)) || !HighlightStyle.isHexDigit(string.charAt(6))) return null;
        return new HighlightStyle(new Color(16 * HighlightStyle.hexDigitToInt(string.charAt(1)) + HighlightStyle.hexDigitToInt(string.charAt(2)), 16 * HighlightStyle.hexDigitToInt(string.charAt(3)) + HighlightStyle.hexDigitToInt(string.charAt(4)), 16 * HighlightStyle.hexDigitToInt(string.charAt(5)) + HighlightStyle.hexDigitToInt(string.charAt(6))), bold, italic);
    }

    public static boolean isHexDigit(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f';
    }

    public static int hexDigitToInt(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        throw new IllegalArgumentException();
    }
}

